<?php

namespace Fusionalliance\Controlforms;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FormTableBreak extends Model 
{

    protected $table = 'form_table_breaks';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $visible = array('controlForm', 'formRow');

    public function formRow()
    {
        return $this->belongsTo('FormRow');
    }

    public function controlForm()
    {
        return $this->belongsTo('ControlForm');
    }

}